/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.JOptionPane;
import processing.core.PApplet;
import processing.data.JSONObject;
import processing.net.Client;
import processing.net.Server;

public class BBSHUBv423
extends PApplet {
    private static int FROMLOC = 2;
    private static int FROMAGW = 3;
    String strProd = "BBSHUB";
    String strTitle = String.valueOf(this.strProd) + " (ver 0.423)";
    String MyServerIP = "127.0.0.1";
    int MyServerPort = 8010;
    String AgwIP = "127.0.0.1";
    int AgwPort = 8000;
    int timeout = 0;
    Server MyServer;
    Client AgwClient;
    BBS myBBS = null;
    String EOL = "\r";
    String strConnected = "*** CONNECTED To Station %s" + this.EOL;
    String strDisConnected = "*** DISCONNECTED From Station %s" + this.EOL;
    String strWelcome1 = "[" + this.strProd + "v0.001]" + this.EOL;
    String strWelcome2 = "Welcome To '" + this.strProd + "' Software PBBS" + this.EOL;
    String strPrompt = "ENTER COMMAND: B,K,L,R,S or Help >" + this.EOL;
    String strHelp = "BBS Commands:" + this.EOL + "B             Disconnect from PBBS" + this.EOL + "H             List of BBS Commands" + this.EOL + "K n           Delete Message Number n" + this.EOL + "KM            Delete All My Read Messages" + this.EOL + "L             List Messages I Can Read" + this.EOL + "LB            List Bulletins" + this.EOL + "LM            List My Unread Messages" + this.EOL + "R n           Display Message Number n" + this.EOL + "RM            Read All MyMessages" + this.EOL + "S|SP callsign Send Private Message to Call" + this.EOL + "SB callsign   Send Bulletin Message to Call" + this.EOL;
    ArrayList<Connection> ConnectionList = new ArrayList();
    int HDRSIZE = 36;
    int AGWPORT = 0;
    int DATAKIND = 4;
    int PID = 6;
    int CALLFROM = 8;
    int CALLTO = 18;
    int DATALEN = 28;
    int USERRESV = 32;
    int DATABLOC = this.HDRSIZE;
    int MAXDATALEN = 127;
    boolean SENDCONNECTED = false;
    boolean LOGTOFILE = false;
    String logfilename = "";
    String configBBSPfx = "";
    String configBBSCall = "";
    JSONObject messageDB = new JSONObject();
    String filename = "messages.json";
    String LASTMSGNUM = "LASTMSGNUM";
    String strTimeFormat = "";
    int marginTop = 20;
    int marginLeft = 10;

    public void setup() {
        BBSHUBv423.println((Object[])new Object[]{"Starting", this.strProd});
        this.loadConfigValues();
        this.surface.setResizable(true);
        this.background(0);
        this.surface.setTitle(this.strTitle);
        this.initLogfile();
        BBSHUBv423.println((String)"starting BBS");
        this.myBBS = new BBS();
        try {
            this.MyServer = new Server((PApplet)this, this.MyServerPort);
            if (this.MyServer.active()) {
                BBSHUBv423.println((String)("server listening on " + this.MyServerIP + ":" + this.MyServerPort));
            } else {
                BBSHUBv423.println((String)("Error: server failed " + this.MyServerIP + ":" + this.MyServerPort));
            }
        }
        catch (Exception exception) {
            BBSHUBv423.println((String)"Error: another instance of programm is already running");
            JOptionPane.showMessageDialog(null, "Error: cannot run multiple instances", String.valueOf(this.strProd) + " - Alert", 0);
            this.noLoop();
            this.exit();
        }
        this.AgwClient = new Client((PApplet)this, this.AgwIP, this.AgwPort);
        if (this.AgwClient.active()) {
            BBSHUBv423.println((String)("connected to agw on " + this.AgwIP + ":" + this.AgwPort));
            BBSHUBv423.println((String)"registering BBS callsign with AGW");
            this.sendFrame(this.AgwClient, this.myBBS.BBSCallSign, "", PApplet.parseByte((char)'X'), PApplet.parseByte((int)0), "");
        } else {
            BBSHUBv423.println((String)("ERROR: not connected to agw on " + this.AgwIP + ":" + this.AgwPort));
            JOptionPane.showMessageDialog(null, "Error: while connecting to Packet Modem\r\nPlease check packet modem & config file", String.valueOf(this.strProd) + " - Alert", 0);
        }
        this.initMessageDB();
    }

    public void draw() {
        Client lclClient;
        if (this.MyServer.active() && (lclClient = this.MyServer.available()) != null && lclClient.available() > 0) {
            this.handleIncoming(lclClient, false);
        }
        if (this.AgwClient.active()) {
            if (this.AgwClient.available() > 0) {
                this.handleIncoming(this.AgwClient, true);
            }
        } else {
            ++this.timeout;
            if (this.timeout >= 500) {
                BBSHUBv423.println((String)"trying to reconnect to agw");
                this.AgwClient = new Client((PApplet)this, this.AgwIP, this.AgwPort);
                if (this.AgwClient.active()) {
                    BBSHUBv423.println((String)"agw re-connected, re-registering BBS with TNC");
                    this.sendFrame(this.AgwClient, this.myBBS.BBSCallSign, "", PApplet.parseByte((char)'X'), PApplet.parseByte((int)0), "");
                }
                this.timeout = 0;
            }
        }
        this.updateScreen();
    }

    public void serverEvent(Server someServer, Client someClient) {
        if (someClient == this.AgwClient) {
            Connection conn = new Connection(someClient, "", FROMAGW);
            this.ConnectionList.add(conn);
            BBSHUBv423.println((Object[])new Object[]{"\r\received new connection from agw, added to list, count=", this.ConnectionList.size()});
        } else {
            Connection conn = new Connection(someClient, "", FROMLOC);
            this.ConnectionList.add(conn);
            BBSHUBv423.print((Object[])new Object[]{"\r\nreceived new connection from local client, list count=", this.ConnectionList.size()});
        }
    }

    public void disconnectEvent(Client someClient) {
        if (someClient == this.AgwClient) {
            BBSHUBv423.println((String)"\r\n\r\nagw disconnected");
            JOptionPane.showMessageDialog(null, "WARNING: TNC disconnected", String.valueOf(this.strProd) + " - Alert", 2);
            this.myBBS.connectedToAGW = false;
        } else {
            BBSHUBv423.println((String)"\r\n\r\nclient disconnected");
        }
        int i = 0;
        while (i < this.ConnectionList.size()) {
            Connection conn = this.ConnectionList.get(i);
            if (conn.cliID == someClient) {
                if (conn.connectedToAGW && conn.cliCall.length() > 0) {
                    this.unregCallsign(conn.cliCall);
                }
                this.ConnectionList.remove(i);
                BBSHUBv423.println((Object[])new Object[]{"list count=", this.ConnectionList.size()});
            }
            ++i;
        }
    }

    public void mouseClicked() {
        int ans;
        if (this.mouseButton == 39 && (ans = JOptionPane.showConfirmDialog(null, "Create Sample Messages?", String.valueOf(this.strProd) + " - Alert", 0)) == 0) {
            this.createDummyMessages();
        }
    }

    public void handleIncoming(Client cli, boolean fromagw) {
        int n = cli.available();
        byte[] buffer = new byte[n];
        n = cli.readBytes(buffer);
        while (buffer.length > 0) {
            if (n >= this.HDRSIZE) {
                int len = this.getDataLen(buffer);
                byte[] buf2 = BBSHUBv423.subset((byte[])buffer, (int)0, (int)(this.HDRSIZE + len));
                BBSHUBv423.println((String)("\r\n\r\nreceived from " + (fromagw ? "agw " : "client ") + n));
                this.printar(buf2);
                buffer = BBSHUBv423.subset((byte[])buffer, (int)(this.HDRSIZE + len));
                if (fromagw) {
                    this.processAgwRequest(cli, buf2);
                    continue;
                }
                this.processClientRequest(cli, buf2);
                continue;
            }
            BBSHUBv423.println((String)"waiting for more bytes...");
        }
    }

    public void processClientRequest(Client cli, byte[] buf) {
        byte dataKind = buf[this.DATAKIND];
        String callFrom = this.getCall(buf, this.CALLFROM).toUpperCase();
        String callTo = this.getCall(buf, this.CALLTO).toUpperCase();
        Client cid = null;
        if (callTo.equals(this.myBBS.BBSCallSign)) {
            BBSHUBv423.println((String)"    pass thru to bbs");
            this.myBBS.handleInput(cli, callFrom, dataKind, buf);
        } else {
            cid = this.getClientForCall(callTo);
            if (cid != null) {
                BBSHUBv423.println((String)"    pass thru to local client");
                cid.write(buf);
            } else {
                BBSHUBv423.println((String)"    pass thru to agw");
                this.sendToAGW(cli, dataKind, callFrom, callTo, buf);
            }
        }
    }

    public void processAgwRequest(Client cli, byte[] buf) {
        byte dataKind = buf[this.DATAKIND];
        String callFrom = this.getCall(buf, this.CALLFROM).toUpperCase();
        String callTo = this.getCall(buf, this.CALLTO).toUpperCase();
        Client cid = null;
        if (callTo.equals(this.myBBS.BBSCallSign) || callFrom.equals(this.myBBS.BBSCallSign)) {
            BBSHUBv423.println((String)"    pass thru to bbs");
            this.myBBS.handleInput(cli, callFrom, dataKind, buf);
        } else {
            cid = this.getClientForCall(callTo);
            if (cid != null) {
                BBSHUBv423.println((Object[])new Object[]{"    pass thru to callTo", callTo});
                cid.write(buf);
            } else {
                cid = this.getClientForCall(callFrom);
                if (cid != null) {
                    if (cid.active()) {
                        BBSHUBv423.println((Object[])new Object[]{"    pass thru to callFrom", callFrom});
                        cid.write(buf);
                        if (dataKind == 88) {
                            if (buf[this.DATABLOC] == 1) {
                                BBSHUBv423.println((Object[])new Object[]{"    registration success for", callFrom});
                                this.getConnectionForClient((Client)cid).connectedToAGW = true;
                            } else {
                                BBSHUBv423.println((Object[])new Object[]{"    WARNING: registration fail for", callFrom});
                                this.getConnectionForClient((Client)cid).connectedToAGW = false;
                            }
                        }
                    } else {
                        BBSHUBv423.println((Object[])new Object[]{"    ERROR: pass thru failed, connection inactive", callFrom});
                    }
                } else if (dataKind == 120) {
                    BBSHUBv423.println((Object[])new Object[]{"    WARNING: client not found for 'x'", callFrom, callTo});
                } else {
                    BBSHUBv423.println((Object[])new Object[]{"    passing thru to all clients", callFrom, callTo, Character.valueOf(PApplet.parseChar((byte)dataKind))});
                    this.MyServer.write(buf);
                }
            }
        }
    }

    public void sendToAGW(Client cli, byte dataKind, String callFrom, String callTo, byte[] buf) {
        if (dataKind == 88) {
            Connection conn = this.getConnectionForClient(cli);
            if (conn != null) {
                conn.cliCall = callFrom;
            }
        } else if (dataKind == 120) {
            Connection conn = this.getConnectionForClient(cli);
            conn.cliCall = "";
            conn.connectedToAGW = false;
            conn.connectedToBBS = false;
        }
        if (this.AgwClient != null) {
            this.AgwClient.write(buf);
        }
    }

    public Client getClientForCall(String callsign) {
        Client retval = null;
        if (callsign.length() > 0) {
            for (Connection connObj : this.ConnectionList) {
                if (!connObj.cliCall.equals(callsign)) continue;
                retval = connObj.cliID;
                break;
            }
        }
        return retval;
    }

    public Connection getConnectionForCall(String callsign) {
        Connection retval = null;
        for (Connection conn : this.ConnectionList) {
            if (conn.cliCall.length() <= 0 || !conn.cliCall.equals(callsign)) continue;
            retval = conn;
            break;
        }
        return retval;
    }

    public Connection getConnectionForClient(Client cli) {
        Connection retval = null;
        for (Connection conn : this.ConnectionList) {
            if (conn.cliID != cli) continue;
            retval = conn;
            break;
        }
        return retval;
    }

    public boolean isConnected(Client cli) {
        boolean retval = false;
        if (cli == null) {
            for (Connection connObj : this.ConnectionList) {
                if (connObj.cliID != cli) continue;
                retval = true;
                break;
            }
        }
        return retval;
    }

    public void regCallsign(String cs) {
        if (cs.length() <= 9) {
            byte dataKind = PApplet.parseByte((char)'X');
            this.sendFrame(this.AgwClient, cs, "", dataKind, PApplet.parseByte((int)0), "");
        } else {
            BBSHUBv423.println((String)"    WARNING: callsign too long");
        }
    }

    public void unregCallsign(String cs) {
        if (cs.length() <= 9) {
            byte dataKind = PApplet.parseByte((char)'x');
            this.sendFrame(this.AgwClient, cs, "", dataKind, PApplet.parseByte((int)0), "");
        } else {
            BBSHUBv423.println((String)"    WARNING: callsign too long");
        }
    }

    public void getConnections(JSONObject conn) {
        if (this.ConnectionList != null && this.ConnectionList.size() > 0) {
            for (Connection connObj : this.ConnectionList) {
                if (connObj.cliCall.length() <= 0) continue;
                if (connObj.connectedToAGW) {
                    conn.setString(connObj.cliCall, "Connected to TNC");
                }
                if (!connObj.connectedToBBS) continue;
                conn.setString(connObj.cliCall, "Connected to BBS");
            }
        }
    }

    public String getCall(byte[] frame, int offset) {
        String cs = "";
        int i = offset;
        while (i < offset + 9) {
            if (frame[i] == 0) break;
            cs = String.valueOf(cs) + PApplet.parseChar((byte)frame[i]);
            ++i;
        }
        return cs;
    }

    public void setCall(byte[] frame, int offset, String cs) {
        if (cs == null) {
            cs = "";
        }
        int i = 0;
        while (i < 9) {
            frame[offset + i] = i < cs.length() ? PApplet.parseByte((char)cs.charAt(i)) : (byte)0;
            ++i;
        }
        frame[offset + 9] = 0;
    }

    public int getDataLen(byte[] frame) {
        String s = "";
        int i = 3;
        while (i >= 0) {
            s = String.valueOf(s) + String.format("%02X", frame[this.DATALEN + i]);
            --i;
        }
        int dataLen = BBSHUBv423.unhex((String)s);
        return dataLen;
    }

    public void setDataLen(byte[] frame, int dataLen) {
        int i = 0;
        while (i <= 3) {
            frame[this.DATALEN + i] = (byte)(dataLen & 0xFF);
            dataLen >>= 8;
            ++i;
        }
    }

    public String getDataBlock(byte[] frame) {
        int dataLen = this.getDataLen(frame);
        String strData = "";
        int i = 0;
        while (i < dataLen) {
            strData = String.valueOf(strData) + PApplet.parseChar((byte)frame[this.DATABLOC + i]);
            ++i;
        }
        return strData;
    }

    public void setDataBlock(byte[] frame, String strData) {
        int i = 0;
        while (i < strData.length()) {
            frame[this.DATABLOC + i] = PApplet.parseByte((char)strData.charAt(i));
            ++i;
        }
    }

    public void sendResponse(Client cli, String callFrom, String callTo, byte kind, byte pid, String strResp) {
        while (strResp.length() > 0) {
            String strSend = "";
            if (strResp.length() > this.MAXDATALEN) {
                strSend = strResp.substring(0, this.MAXDATALEN);
                strResp = strResp.substring(this.MAXDATALEN);
            } else {
                strSend = strResp;
                strResp = "";
            }
            if (cli != null && cli.active()) {
                this.sendFrame(cli, callFrom, callTo, kind, pid, strSend);
                this.delay(100);
                continue;
            }
            if (cli == null) {
                BBSHUBv423.println((String)"ERROR: cli is null in sendResponse");
                continue;
            }
            if (cli.active()) continue;
            BBSHUBv423.println((String)"ERROR: cli is not active in sendResponse");
        }
    }

    public void sendFrame(Client cli, String callFrom, String callTo, byte kind, byte pid, String strData) {
        int dlen = strData.length();
        byte[] frame = new byte[this.HDRSIZE + dlen];
        int i = 0;
        while (i < frame.length) {
            frame[i] = 0;
            ++i;
        }
        frame[0] = 0;
        frame[this.DATAKIND] = kind;
        frame[this.PID] = pid;
        this.setCall(frame, this.CALLFROM, callFrom);
        this.setCall(frame, this.CALLTO, callTo);
        this.setDataLen(frame, dlen);
        if (strData.length() > 0) {
            this.setDataBlock(frame, strData);
        }
        this.printar(frame);
        if (cli != null && cli.active()) {
            cli.write(frame);
        } else if (cli == null) {
            BBSHUBv423.println((String)"ERROR: cli is null, unable to write frame");
        } else if (!cli.active()) {
            BBSHUBv423.println((String)"ERROR: cli is not active, unable to write frame");
        }
    }

    public void loadConfigValues() {
        try {
            JSONObject config = this.loadJSONObject(this.sketchPath("config.txt"));
            BBSHUBv423.println((String)("loading config values " + config.size()));
            if (!config.isNull("LOGGING")) {
                this.LOGTOFILE = config.getBoolean("LOGGING");
            }
            if (!config.isNull("HUBPORT")) {
                this.MyServerPort = PApplet.parseInt((String)config.getString("HUBPORT"));
            }
            if (!config.isNull("TNCPORT")) {
                this.AgwPort = PApplet.parseInt((String)config.getString("TNCPORT"));
            }
            if (!config.isNull("TNCIP")) {
                this.AgwIP = config.getString("TNCIP");
            }
            if (!config.isNull("BBSCALL")) {
                this.configBBSCall = config.getString("BBSCALL").toUpperCase();
                if (this.configBBSCall.length() > 9) {
                    this.configBBSCall = this.configBBSCall.substring(0, 9);
                    JOptionPane.showMessageDialog(null, "WARNING: BBSCALL TRUNCATED,\r\nIt cannot be more than 9 characyers long,\r\nPlease update Config file and restart program.", String.valueOf(this.strProd) + " - Alert", 2);
                }
            }
            if (!config.isNull("BBSPREFIX")) {
                this.configBBSPfx = config.getString("BBSPREFIX");
                if (this.configBBSPfx.length() > 6) {
                    this.configBBSPfx = this.configBBSPfx.substring(0, 6);
                }
                if (this.configBBSPfx.length() > 0) {
                    this.strWelcome1 = this.strWelcome1.replace(this.strProd, String.valueOf(this.configBBSPfx) + "-" + this.strProd);
                }
            }
            if (!config.isNull("BBSPROMPT")) {
                this.strPrompt = String.valueOf(config.getString("BBSPROMPT")) + this.EOL;
            }
            if (!config.isNull("SENDCONNECT")) {
                this.SENDCONNECTED = config.getBoolean("SENDCONNECT");
            }
            if (!config.isNull("LOGGING")) {
                this.LOGTOFILE = config.getBoolean("LOGGING");
            }
        }
        catch (Exception e) {
            BBSHUBv423.println((String)"Error: while reading config file");
            JOptionPane.showMessageDialog(null, "Error: while reading config file" + e, String.valueOf(this.strProd) + " - Alert", 0);
        }
    }

    public void initLogfile() {
        if (this.LOGTOFILE) {
            this.logfilename = String.format(String.valueOf(this.sketchPath()) + "\\log\\bbshub_" + "%4d%02d%02d_%02d%02d%02d.log", BBSHUBv423.year(), BBSHUBv423.month(), BBSHUBv423.day(), BBSHUBv423.hour(), BBSHUBv423.minute(), BBSHUBv423.second());
            BBSHUBv423.println((String)"redirecting to log file: ");
            try {
                PrintWriter f = this.createWriter(this.sketchPath(this.logfilename));
                if (f != null) {
                    f.write("");
                    f.flush();
                    f.close();
                }
                PrintStream psLog = new PrintStream(new File(this.logfilename));
                System.setOut(psLog);
            }
            catch (Exception e) {
                BBSHUBv423.println((Object[])new Object[]{"Error: Unable to open log File", e});
                JOptionPane.showMessageDialog(null, "Error: Unable to open log File " + e, String.valueOf(this.strProd) + " - Alert", 0);
            }
        }
    }

    public void printar(byte[] ar) {
        int n = ar.length;
        if (n > 0) {
            String s1 = "";
            String s2 = "";
            int i = 0;
            while (i < n) {
                if (i > 0 && i / 16 * 16 == i) {
                    s1 = String.valueOf(s1) + "\r\n";
                }
                s1 = String.valueOf(s1) + BBSHUBv423.hex((int)ar[i], (int)2) + " ";
                s2 = ar[i] >= 32 && ar[i] <= 126 ? String.valueOf(s2) + PApplet.parseChar((byte)ar[i]) : String.valueOf(s2) + '.';
                ++i;
            }
            BBSHUBv423.println((String)(String.valueOf(s1) + "\r\n" + s2));
        }
    }

    public void printHex(String str) {
        int i = 0;
        while (i < str.length()) {
            BBSHUBv423.print((String)(String.valueOf(BBSHUBv423.hex((int)str.charAt(i), (int)2)) + " "));
            ++i;
        }
        BBSHUBv423.println();
    }

    public void initMessageDB() {
        File f = new File(this.dataPath(this.filename));
        if (!f.exists()) {
            JSONObject obj = new JSONObject();
            obj.setInt(this.LASTMSGNUM, 0);
            this.messageDB.setJSONObject("0", obj);
            this.saveMessagesJSON();
        } else {
            this.loadMessagesJSON();
        }
    }

    public void loadMessagesJSON() {
        this.messageDB = this.loadJSONObject(this.filename);
    }

    public void saveMessagesJSON() {
        this.saveJSONObject(this.messageDB, this.dataPath(this.filename));
    }

    public int getNumMessages() {
        return this.messageDB.size();
    }

    public int getMinMsgNum() {
        int minKey = 0;
        if (this.messageDB != null && this.messageDB.size() > 0) {
            Iterator keys = this.messageDB.keyIterator();
            while (keys.hasNext()) {
                int intKey = PApplet.parseInt((String)((String)keys.next()));
                if (minKey == 0) {
                    minKey = intKey;
                    continue;
                }
                if (intKey >= minKey) continue;
                minKey = intKey;
            }
        }
        return minKey;
    }

    public int getMaxMsgNum() {
        int maxKey = 0;
        if (this.messageDB != null && this.messageDB.size() > 0) {
            Iterator keys = this.messageDB.keyIterator();
            while (keys.hasNext()) {
                int intKey = PApplet.parseInt((String)((String)keys.next()));
                if (maxKey == 0) {
                    maxKey = intKey;
                    continue;
                }
                if (intKey <= maxKey) continue;
                maxKey = intKey;
            }
        }
        return maxKey;
    }

    public int getMsgBlocks() {
        return 999;
    }

    public int getLastMessageNum() {
        String strNum = "0";
        int intResp = 0;
        if (this.messageDB != null && this.messageDB.size() > 0 && this.messageDB.get(strNum) instanceof JSONObject) {
            JSONObject msg = this.messageDB.getJSONObject(strNum);
            intResp = msg.getInt(this.LASTMSGNUM);
        }
        return intResp;
    }

    public void setLastMessageNum(int intNum) {
        JSONObject obj = new JSONObject();
        obj.setInt(this.LASTMSGNUM, intNum);
        this.messageDB.setJSONObject("0", obj);
        this.saveMessagesJSON();
    }

    public int getNewMessageNum() {
        int intNum = this.getLastMessageNum();
        this.setLastMessageNum(++intNum);
        return intNum;
    }

    public void getMsgCounts(JSONObject numMsgs) {
        if (this.messageDB != null && this.messageDB.size() > 0) {
            Iterator keys = this.messageDB.keyIterator();
            while (keys.hasNext()) {
                String k = (String)keys.next();
                if (k.equals("0") || !(this.messageDB.get(k) instanceof JSONObject)) continue;
                JSONObject msg = this.messageDB.getJSONObject(k);
                String strTo = msg.getString("to");
                if (!numMsgs.isNull(strTo)) {
                    int n = numMsgs.getInt(strTo);
                    numMsgs.setInt(strTo, n + 1);
                    continue;
                }
                numMsgs.setInt(strTo, 1);
            }
        }
    }

    public String listMessages(String req, String cs) {
        String strFmt = "%-5s %-2s %-6s %-9s %-9s %-19s  %s" + this.EOL;
        String strTitles = String.format(strFmt, "MSG#", "ST", "SIZE", "TO", "FROM", "DATE", "SUBJECT");
        String strResp = this.EOL;
        if (this.messageDB != null && this.messageDB.size() > 0) {
            Iterator keys = this.messageDB.keyIterator();
            while (keys.hasNext()) {
                String k = (String)keys.next();
                if (k.equals("0") || !(this.messageDB.get(k) instanceof JSONObject)) continue;
                JSONObject msg = this.messageDB.getJSONObject(k);
                String strSts = msg.getString("st");
                String strSize = msg.getString("sz");
                String strTo = msg.getString("to");
                String strFrom = msg.getString("fr");
                String strTime = msg.getString("tm");
                String strSubj = msg.getString("sb");
                boolean cond = false;
                if (req.equals("L")) {
                    cond = strFrom.equals(cs) || strTo.equals(cs) || strTo.equals("ALL");
                } else if (req.equals("LM")) {
                    cond = strTo.equals(cs) && strSts.equals("PN");
                } else if (req.equals("LB")) {
                    boolean bl = cond = (strTo.equals(cs) || strTo.equals("ALL")) && strSts.charAt(0) == 'B';
                }
                if (!cond) continue;
                if (strResp.equals(this.EOL)) {
                    strResp = String.valueOf(strResp) + strTitles;
                }
                strResp = String.valueOf(strResp) + String.format(strFmt, k, strSts, strSize, strTo, strFrom, strTime, strSubj);
            }
        }
        return strResp;
    }

    public String getMessage(String cs, int num) {
        String strNum = "" + num;
        String strResp = "";
        String strFmt = String.valueOf(this.EOL) + "MSG#%s %s FROM %s TO %s" + this.EOL + "SUBJECT: %s" + this.EOL + "PATH: %s" + this.EOL + "%s";
        if (this.messageDB != null && this.messageDB.size() > 0) {
            if (this.messageDB.get(strNum) instanceof JSONObject) {
                JSONObject msg = this.messageDB.getJSONObject(strNum);
                String strTo = msg.getString("to");
                String strFrom = msg.getString("fr");
                String strTime = msg.getString("tm");
                String strSubj = msg.getString("sb");
                String strSts = msg.getString("st");
                if (strTo.equals("ALL") || strFrom.equals(cs) || strTo.equals(cs)) {
                    String strBody = this.readMsgFile("msg" + strNum + ".txt");
                    strResp = String.format(strFmt, strNum, strTime, strFrom, strTo, strSubj, this.myBBS.BBSCallSign, strBody);
                    if (strTo.equals(cs)) {
                        if (strSts.equals("PN")) {
                            msg.setString("st", "P");
                        }
                        if (strSts.equals("BN")) {
                            msg.setString("st", "B");
                        }
                        msg.setJSONObject(strNum, msg);
                    }
                } else {
                    strResp = "Cannot read message #" + num + this.EOL;
                }
            } else {
                strResp = "There is no message #" + num + this.EOL;
            }
        } else {
            strResp = "There are no messages" + this.EOL;
        }
        return strResp;
    }

    public void addMessage(int iNum, String strSts, String strTo, String strFrom, String strTime, String strSubj, String strBody) {
        String strSize = String.format("%s", strBody.length());
        JSONObject msg = new JSONObject();
        msg.setString("st", strSts);
        msg.setString("sz", strSize);
        msg.setString("fr", strFrom);
        msg.setString("to", strTo);
        msg.setString("sb", strSubj);
        msg.setString("tm", strTime);
        String strNum = "" + iNum;
        this.messageDB.setJSONObject(strNum, msg);
        this.saveMessagesJSON();
        String strFName = "msg" + iNum + ".txt";
        this.writeMsgFile(this.dataPath(strFName), strBody);
    }

    public String delMessage(String myCall, int num) {
        BBSHUBv423.print((Object[])new Object[]{"    deleteing message", num});
        String strFmt = String.valueOf(this.EOL) + "MSG#%d %s FROM %s TO %s" + this.EOL + "MESSAGE DELETED" + this.EOL;
        String strNum = "" + num;
        String strResp = "";
        if (this.messageDB != null && this.messageDB.size() > 0) {
            if (this.messageDB.get(strNum) instanceof JSONObject) {
                JSONObject msg = this.messageDB.getJSONObject(strNum);
                String strTo = msg.getString("to");
                String strFrom = msg.getString("fr");
                String strTime = msg.getString("tm");
                if (strFrom.equals(myCall) || strTo.equals(myCall)) {
                    strResp = String.format(strFmt, num, strTime, strFrom, strTo);
                    this.messageDB.remove(strNum);
                    this.saveMessagesJSON();
                    String strFName = "msg" + num + ".txt";
                    this.deleteMsgFile(strFName);
                } else {
                    strResp = "Cannot Deleted Message #" + strNum + this.EOL;
                }
            } else {
                strResp = "There is no message #" + strNum + this.EOL;
            }
        } else {
            strResp = "There are no messages" + this.EOL;
        }
        return strResp;
    }

    public void writeMsgFile(String fname, String body) {
        PrintWriter f = this.createWriter(this.dataPath(fname));
        if (f != null) {
            f.write(body);
            f.flush();
            f.close();
        }
    }

    public String readMsgFile(String fname) {
        String strBody = "";
        String strLine = null;
        BufferedReader f = this.createReader(this.dataPath(fname));
        if (f != null) {
            try {
                while ((strLine = f.readLine()) != null) {
                    strBody = String.valueOf(strBody) + strLine + this.EOL;
                }
                f.close();
            }
            catch (IOException e) {
                strBody = "ERROR reading message: " + fname;
                e.printStackTrace();
            }
        } else {
            strBody = "ERROR: message " + fname + " not found";
        }
        return strBody;
    }

    public void deleteMsgFile(String fname) {
        File f = new File(this.dataPath(fname));
        if (!f.delete()) {
            BBSHUBv423.println((String)"Error: Message file deletion failed");
        }
    }

    public void createDummyMessages() {
        this.addMessage(this.getNewMessageNum(), "PN", "ALL", "TESTER", "03/21/2019 14:30:04", "test 1", "This is test 1");
        this.addMessage(this.getNewMessageNum(), "B", "ALL", "TESTER", "03/21/2019 14:30:04", "test 2", "This is test 2");
        this.addMessage(this.getNewMessageNum(), "PN", "FREC", "TESTER", "03/22/2019 15:31:04", "test 3", "This is test 3");
        this.addMessage(this.getNewMessageNum(), "PN", "K6VUG", "TESTER", "03/23/2019 16:32:04", "test 4", "This is test 4");
        this.addMessage(this.getNewMessageNum(), "B", "FREC", "TESTER", "03/23/2019 16:32:04", "test 5", "This is test 5");
    }

    public void updateScreen() {
        int yoffset = this.marginTop;
        this.background(0);
        this.textSize(20.0f);
        this.text(String.valueOf(this.strProd) + ", Packet Software", this.marginLeft, yoffset);
        this.textSize(12.0f);
        this.text("Developed by Umesh Ghodke (K6VUG), Apr 2019", this.marginLeft, yoffset += 15);
        this.stroke(255);
        this.strokeWeight(1.0f);
        this.line(0.0f, yoffset += 10, 320.0f, yoffset);
        this.textSize(12.0f);
        this.text(String.valueOf(this.MyServer != null ? "BBS Port:" : "ERROR:") + this.MyServerPort, this.marginLeft, yoffset += 18);
        this.text("BBS Call: " + this.myBBS.BBSCallSign, this.marginLeft + 120, yoffset);
        this.text(this.SENDCONNECTED ? "Y" : "N", this.marginLeft + 290, yoffset);
        this.textSize(12.0f);
        this.text("TNC Port:" + this.AgwPort, this.marginLeft, yoffset += 15);
        this.text(this.AgwClient.active() ? "STATUS: CONNECTED" : "ERROR: NOT CONNECTED", this.marginLeft + 120, yoffset);
        this.stroke(255);
        this.strokeWeight(1.0f);
        this.line(0.0f, yoffset += 10, 320.0f, yoffset);
        this.textSize(14.0f);
        this.text("CallSigns    Messages", this.marginLeft, yoffset += 20);
        JSONObject numMsgs = new JSONObject();
        this.getMsgCounts(numMsgs);
        this.textSize(12.0f);
        if (numMsgs.size() > 0) {
            Iterator keys = numMsgs.keyIterator();
            while (keys.hasNext()) {
                String k = (String)keys.next();
                int n = numMsgs.getInt(k);
                this.text(k, this.marginLeft, this.marginTop + yoffset);
                this.text(n, this.marginLeft + 100, this.marginTop + yoffset);
                yoffset += 20;
            }
        }
        this.stroke(255);
        this.strokeWeight(1.0f);
        this.line(0.0f, yoffset += 10, 320.0f, yoffset);
        this.textSize(14.0f);
        this.text("Connections", this.marginLeft, yoffset += 20);
        JSONObject connList = new JSONObject();
        this.getConnections(connList);
        this.textSize(12.0f);
        if (connList.size() > 0) {
            Iterator keys = connList.keyIterator();
            while (keys.hasNext()) {
                String k = (String)keys.next();
                String s = connList.getString(k);
                this.text(k, this.marginLeft, this.marginTop + yoffset);
                this.text(s, this.marginLeft + 100, this.marginTop + yoffset);
                yoffset += 20;
            }
        }
    }

    public void settings() {
        this.size(320, 320);
    }

    public static void main(String[] passedArgs) {
        String[] appletArgs = new String[]{"BBSHUBv423"};
        if (passedArgs != null) {
            PApplet.main((String[])BBSHUBv423.concat((String[])appletArgs, (String[])passedArgs));
        } else {
            PApplet.main((String[])appletArgs);
        }
    }

    class BBS {
        String BBSCallSign = "K6VUG-2";
        boolean connectedToAGW = false;

        BBS() {
            if (BBSHUBv423.this.configBBSCall.length() > 0) {
                this.BBSCallSign = BBSHUBv423.this.configBBSCall;
            }
        }

        public void handleInput(Client cli, String callFrom, byte dataKind, byte[] buf) {
            if (callFrom.equals(this.BBSCallSign)) {
                if (dataKind == 88) {
                    BBSHUBv423.println((String)"    bbs registered with agw successfully");
                    this.connectedToAGW = true;
                } else if (dataKind == 120) {
                    BBSHUBv423.println((String)"    bbs unregistered from agw");
                    this.connectedToAGW = false;
                } else if (dataKind == 100) {
                    BBSHUBv423.println((String)"    disconnection ack for bbs received from agw");
                } else {
                    BBSHUBv423.println((Object[])new Object[]{"    WARNING: ignoring message to bbs, kind", Character.valueOf(PApplet.parseChar((byte)dataKind))});
                }
            } else {
                Connection conn = this.getConnectionForCall(callFrom);
                if (conn != null) {
                    conn.appendInput(buf);
                    this.processRequest(conn);
                } else if (dataKind == 67 && cli == BBSHUBv423.this.AgwClient) {
                    conn = new Connection(cli, callFrom, FROMAGW);
                    BBSHUBv423.this.ConnectionList.add(conn);
                    BBSHUBv423.println((Object[])new Object[]{"\r\nreceived connection request from agw, added to list, list count=", BBSHUBv423.this.ConnectionList.size()});
                    conn.appendInput(buf);
                    this.processRequest(conn);
                } else {
                    BBSHUBv423.println((Object[])new Object[]{"ERROR: connection object not found for ", callFrom});
                }
            }
        }

        public void processRequest(Connection conn) {
            if (conn.szInBuffer >= BBSHUBv423.this.HDRSIZE) {
                int datalen = BBSHUBv423.this.getDataLen(conn.inBuffer);
                int framelen = BBSHUBv423.this.HDRSIZE + datalen;
                byte[] buf = BBSHUBv423.subset((byte[])conn.inBuffer, (int)0, (int)framelen);
                int i = 0;
                while (i < conn.inBuffer.length - framelen) {
                    conn.inBuffer[i] = conn.inBuffer[i + framelen];
                    ++i;
                }
                this.parseRequest(buf);
                conn.szInBuffer -= framelen;
            }
        }

        private void parseRequest(byte[] buffer) {
            block14: {
                String callTo;
                String callFrom;
                byte dataKind;
                block13: {
                    dataKind = buffer[BBSHUBv423.this.DATAKIND];
                    callFrom = BBSHUBv423.trim((String)BBSHUBv423.this.getCall(buffer, BBSHUBv423.this.CALLFROM)).toUpperCase();
                    callTo = BBSHUBv423.trim((String)BBSHUBv423.this.getCall(buffer, BBSHUBv423.this.CALLTO)).toUpperCase();
                    Connection conn = this.getConnectionForCall(callFrom);
                    if (!callTo.equals(this.BBSCallSign)) break block13;
                    switch (dataKind) {
                        case 67: 
                        case 118: {
                            if (!conn.connectedToBBS) {
                                BBSHUBv423.println((Object[])new Object[]{"    connecting to BBS", callTo, callFrom});
                                conn.connectedToBBS = true;
                                this.sendWelcome(conn);
                                break;
                            }
                            BBSHUBv423.println((String)"    re-connecting to bbs");
                            this.sendBBSPrompt(conn);
                            break;
                        }
                        case 100: {
                            if (conn != null) {
                                conn.connectedToBBS = false;
                                this.sendAX25Disconnected(conn);
                                break;
                            }
                            break block14;
                        }
                        case 68: {
                            if (conn.connectedToBBS) {
                                String strData = BBSHUBv423.this.getDataBlock(buffer);
                                if (conn.MESSAGE_STATE > 0) {
                                    this.createMessage(conn, "", strData);
                                    break;
                                }
                                String strCmd = "";
                                int n = strData.indexOf(" ");
                                if (n == -1) {
                                    strCmd = BBSHUBv423.trim((String)strData);
                                    strData = "";
                                } else {
                                    strCmd = BBSHUBv423.trim((String)strData.substring(0, n));
                                    strData = strData.substring(n + 1);
                                }
                                this.procBBSCmds(conn, BBSHUBv423.trim((String)strCmd), strData);
                                break;
                            }
                            break block14;
                        }
                        default: {
                            BBSHUBv423.println((Object[])new Object[]{"    WARNING: request not processed ", Character.valueOf(PApplet.parseChar((byte)dataKind))});
                            break;
                        }
                    }
                    break block14;
                }
                if (callFrom.equals(this.BBSCallSign) && dataKind == 88) {
                    BBSHUBv423.println((String)"    WARNING: registration ack received (2)");
                } else {
                    BBSHUBv423.println((Object[])new Object[]{"    ERROR: message dropped for callFrom", callFrom, "callTo", callTo, "datakind", dataKind});
                }
            }
        }

        private void procBBSCmds(Connection conn, String strCmd, String strData) {
            strCmd = BBSHUBv423.trim((String)strCmd.toUpperCase());
            int msgNum = 0;
            String strResponse = "";
            switch (strCmd) {
                case "B": {
                    this.sendBBSDisconnected(conn);
                    conn.connectedToBBS = false;
                    break;
                }
                case "H": {
                    strResponse = BBSHUBv423.this.strHelp;
                    BBSHUBv423.this.sendResponse(conn.cliID, BBSHUBv423.this.myBBS.BBSCallSign, conn.cliCall, PApplet.parseByte((char)'D'), PApplet.parseByte((int)240), strResponse);
                    this.sendBBSPrompt(conn);
                    break;
                }
                case "R": {
                    if (!strData.equals("")) {
                        msgNum = PApplet.parseInt((String)BBSHUBv423.trim((String)strData));
                        strResponse = String.valueOf(BBSHUBv423.this.getMessage(conn.cliCall, msgNum)) + BBSHUBv423.this.EOL;
                        BBSHUBv423.this.sendResponse(conn.cliID, BBSHUBv423.this.myBBS.BBSCallSign, conn.cliCall, PApplet.parseByte((char)'D'), PApplet.parseByte((int)240), strResponse);
                    }
                    this.sendBBSPrompt(conn);
                    break;
                }
                case "L": 
                case "LB": 
                case "LM": {
                    strResponse = BBSHUBv423.this.listMessages(strCmd, conn.cliCall);
                    BBSHUBv423.this.sendResponse(conn.cliID, BBSHUBv423.this.myBBS.BBSCallSign, conn.cliCall, PApplet.parseByte((char)'D'), PApplet.parseByte((int)240), strResponse);
                    this.sendBBSPrompt(conn);
                    break;
                }
                case "K": {
                    if (!strData.equals("")) {
                        msgNum = PApplet.parseInt((String)BBSHUBv423.trim((String)strData));
                        strResponse = BBSHUBv423.this.delMessage(conn.cliCall, msgNum);
                        BBSHUBv423.this.sendResponse(conn.cliID, BBSHUBv423.this.myBBS.BBSCallSign, conn.cliCall, PApplet.parseByte((char)'D'), PApplet.parseByte((int)240), strResponse);
                    }
                    this.sendBBSPrompt(conn);
                    break;
                }
                case "S": 
                case "SP": {
                    this.createMessage(conn, "P", strData);
                    break;
                }
                case "SB": {
                    this.createMessage(conn, "B", strData);
                    break;
                }
                default: {
                    BBSHUBv423.println((Object[])new Object[]{"    WARNING: unhandled bbs command", strCmd});
                    this.sendBBSPrompt(conn);
                }
            }
        }

        private void createMessage(Connection conn, String strTyp, String strIn) {
            String strResponse = "";
            NewMessage newMsg = null;
            if (conn.MESSAGE_STATE == 0) {
                newMsg = new NewMessage();
                newMsg.msgNum = BBSHUBv423.this.getNewMessageNum();
                newMsg.strFrom = conn.cliCall;
                newMsg.strSts = String.valueOf(strTyp) + (strTyp.equals("P") ? "N" : "");
                conn.newMsg = newMsg;
                conn.MESSAGE_STATE = 1;
            }
            if ((strResponse = this.populateMessage(conn, conn.newMsg, strIn)).length() > 0) {
                BBSHUBv423.this.sendResponse(conn.cliID, BBSHUBv423.this.myBBS.BBSCallSign, conn.cliCall, PApplet.parseByte((char)'D'), PApplet.parseByte((int)240), strResponse);
            }
            if (conn.MESSAGE_STATE == 4) {
                this.sendBBSPrompt(conn);
                conn.MESSAGE_STATE = 0;
            }
        }

        public String populateMessage(Connection conn, NewMessage newMsg, String strIn) {
            String strResponse = "";
            strIn = strIn.replace("\n", "");
            String[] strArray = BBSHUBv423.split((String)strIn, (String)"\r");
            int i = 0;
            while (i < strArray.length) {
                String strLine = strArray[i];
                switch (conn.MESSAGE_STATE) {
                    case 1: {
                        int len = BBSHUBv423.trim((String)strLine).length();
                        if (len > 0 && len <= 8) {
                            newMsg.strTo = BBSHUBv423.trim((String)strLine.toUpperCase());
                            conn.MESSAGE_STATE = 2;
                            strResponse = "Enter Subject: ";
                            break;
                        }
                        conn.MESSAGE_STATE = 1;
                        strResponse = "Enter Callsign: ";
                        break;
                    }
                    case 2: {
                        if (BBSHUBv423.trim((String)strLine).length() > 0) {
                            newMsg.strSubj = BBSHUBv423.trim((String)strLine);
                            conn.MESSAGE_STATE = 3;
                            strResponse = "Enter Message, End With '/EX' On A Line By Itself" + BBSHUBv423.this.EOL;
                            break;
                        }
                        conn.MESSAGE_STATE = 2;
                        strResponse = "Enter Subject: ";
                        break;
                    }
                    case 3: {
                        boolean isCtrlZ;
                        boolean bl = isCtrlZ = strLine.length() == 1 && PApplet.parseByte((char)strLine.charAt(0)) == 26;
                        if (strArray[i].equalsIgnoreCase("/EX") || isCtrlZ) {
                            this.saveNewMessage(newMsg);
                            conn.MESSAGE_STATE = 4;
                            strResponse = "Message Saved" + BBSHUBv423.this.EOL;
                            break;
                        }
                        if (i == strArray.length - 1 && strLine.length() == 0) break;
                        newMsg.strBody = String.valueOf(newMsg.strBody) + strLine + BBSHUBv423.this.EOL;
                        conn.MESSAGE_STATE = 3;
                        strResponse = "";
                        break;
                    }
                    default: {
                        BBSHUBv423.println((String)"    WARNING: message creation sequence went wrong");
                    }
                }
                ++i;
            }
            return strResponse;
        }

        public void saveNewMessage(NewMessage newMsg) {
            String strTimeFormat = "%02d/%02d/%4d %02d:%02d:%02d";
            newMsg.strTime = String.format(strTimeFormat, BBSHUBv423.month(), BBSHUBv423.day(), BBSHUBv423.year(), BBSHUBv423.hour(), BBSHUBv423.minute(), BBSHUBv423.second());
            BBSHUBv423.this.addMessage(newMsg.msgNum, newMsg.strSts, newMsg.strTo, newMsg.strFrom, newMsg.strTime, newMsg.strSubj, newMsg.strBody);
        }

        public void sendWelcome(Connection conn) {
            if (BBSHUBv423.this.SENDCONNECTED) {
                this.sendBBSConnected(conn);
            }
            BBSHUBv423.this.delay(500);
            this.sendBBSWelcome(conn);
        }

        private void sendBBSWelcome(Connection conn) {
            BBSHUBv423.println((String)"\r\n\r\nsending from bbs - welcome message");
            int nBytes = 1000000;
            int nBlocks = BBSHUBv423.this.getMsgBlocks();
            int nMsgs = BBSHUBv423.this.getNumMessages();
            int n1 = BBSHUBv423.this.getMinMsgNum();
            int n2 = BBSHUBv423.this.getLastMessageNum();
            String strResponse = String.format(String.valueOf(BBSHUBv423.this.strWelcome1) + BBSHUBv423.this.strWelcome2 + BBSHUBv423.this.strPrompt, nBytes, nBlocks, nMsgs, n1, n2);
            BBSHUBv423.this.sendResponse(conn.cliID, this.BBSCallSign, conn.cliCall, PApplet.parseByte((char)'D'), PApplet.parseByte((int)240), strResponse);
        }

        private void sendBBSPrompt(Connection conn) {
            BBSHUBv423.println((String)"\r\n\r\nsending from bbs - bbs prompt");
            BBSHUBv423.this.sendResponse(conn.cliID, this.BBSCallSign, conn.cliCall, PApplet.parseByte((char)'D'), PApplet.parseByte((int)240), BBSHUBv423.this.strPrompt);
        }

        private void sendBBSConnected(Connection conn) {
            BBSHUBv423.println((String)"\r\n\r\nsending from bbs - connection ack");
            String strResponse = String.format(BBSHUBv423.this.strConnected, this.BBSCallSign);
            BBSHUBv423.this.sendResponse(conn.cliID, this.BBSCallSign, conn.cliCall, PApplet.parseByte((char)'C'), PApplet.parseByte((int)0), strResponse);
        }

        private void sendBBSDisconnected(Connection conn) {
            BBSHUBv423.println((Object[])new Object[]{"\r\n\r\nsending from bbs - bbs disconnect to", conn.cliCall});
            String strResponse = String.format(BBSHUBv423.this.strDisConnected, this.BBSCallSign);
            BBSHUBv423.this.sendResponse(conn.cliID, this.BBSCallSign, conn.cliCall, PApplet.parseByte((char)'d'), PApplet.parseByte((int)0), strResponse);
        }

        private void sendAX25Disconnected(Connection conn) {
            BBSHUBv423.println((Object[])new Object[]{"\r\n\r\nsending from bbs - ax.25 disconnect to", conn.cliCall});
            String strResponse = String.format(BBSHUBv423.this.strDisConnected, conn.cliCall);
            BBSHUBv423.this.sendResponse(conn.cliID, this.BBSCallSign, conn.cliCall, PApplet.parseByte((char)'d'), PApplet.parseByte((int)0), strResponse);
        }

        public Connection getConnectionForCall(String callsign) {
            Connection retval = null;
            for (Connection conn : BBSHUBv423.this.ConnectionList) {
                if (conn.cliCall.length() <= 0 || !conn.cliCall.equals(callsign)) continue;
                retval = conn;
                break;
            }
            return retval;
        }
    }

    class Connection {
        Client cliID = null;
        String cliCall = "";
        int connectedFrom = 0;
        boolean connectedToBBS = false;
        boolean connectedToAGW = false;
        byte[] inBuffer = new byte[1024];
        int szInBuffer = 0;
        private NewMessage newMsg = null;
        private int MESSAGE_STATE = 0;

        Connection(Client c, String cs, int from) {
            this.cliID = c;
            this.cliCall = cs;
            this.connectedFrom = from;
        }

        public void Disconnect() {
            this.connectedToBBS = false;
            this.connectedToAGW = false;
        }

        public void appendInput(byte[] src) {
            if (this.inBuffer != null) {
                int i = 0;
                while (i < src.length) {
                    this.inBuffer[this.szInBuffer + i] = src[i];
                    ++i;
                }
                this.szInBuffer += src.length;
            } else {
                BBSHUBv423.println((String)"    Error: inBuffer is null");
            }
        }
    }

    class NewMessage {
        int msgNum = 0;
        String strTime = "";
        String strFrom = "";
        String strTo = "";
        String strSts = "";
        String strSubj = "";
        String strBody = "";

        NewMessage() {
        }
    }
}

